

CREATE OR REPLACE FUNCTION TQS.Get_QSInfo_Wendat(INOUT wwen INTEGER, OUT q_nr INTEGER, OUT q_typ INTEGER, OUT q_typ_desc VARCHAR(100), OUT wendat_desc VARCHAR(100)) RETURNS RECORD AS $$

 BEGIN
  SELECT w_wen, qab.q_nr, qab.q_typ,
        CASE WHEN qab.q_typ = 2 THEN lang_text(12321) -- Artikelbezogen
             WHEN qab.q_typ = 3 THEN lang_text(12322) -- Wareneingang
             WHEN qab.q_typ = 4 THEN lang_text(12323) -- Lagerabgang
             WHEN qab.q_typ = 5 THEN lang_text(12324) -- Fertigungsauftrag
          ELSE '? - TQS.Get_QSInfo_Wendat => ' || lang_text(29194) /*Unerwarteter QAB-Typ'*/
        END  AS q_typ_desc,
        CASE -- Ohne Bestellung? Reklamationslieferung durch Kunde. => "Reklamation (Kunde)"
             WHEN w_lds_id IS NULL THEN lang_text(13139)
             -- E-Bestellung und QAB ist auf Wareneingang erstellt  => "Reklamierte Lieferung (Einkauf)"
             WHEN w_lds_id IS NOT NULL AND qab.q_w_wen IS NOT NULL AND qab.q_w_wen = w_wen AND ld_code = 'E' THEN lang_text(13140)
             -- E-Bestellung und QAB ist auf anderen Wareneingang erstellt => "Ersatzlieferung (Einkauf)"
             WHEN w_lds_id IS NOT NULL AND qab.q_w_wen IS NOT NULL AND qab.q_w_wen <> w_wen AND ld_code = 'E' THEN lang_text(13142) --Geht nur, wenn Reklamationsbestellung angelegt wurde. Sonst ist Ersatzlieferung nicht von weiterer Teillieferung unterscheidbar
             -- Interne Bestellung? Wenn es das mal gibt Lagerzugang (Nachbearbeitung / Nachfertigung)
             WHEN w_lds_id IS NOT NULL AND ld_code = 'I' THEN lang_text(13140)
          ELSE '? - TQS.Get_QSInfo_Wendat => ' || lang_text(29195)  /*Unerwarteter Wareneingangs-Typ'*/
        END AS wendat_desc
  INTO wwen, q_nr, q_typ, q_typ_desc,wendat_desc
  FROM wendat LEFT JOIN qab ON w_q_nr = qab.q_nr
              LEFT JOIN ldsdok ON w_lds_id = ld_id
  WHERE w_wen = wwen;

  RETURN;
 END $$ LANGUAGE plpgsql STABLE;
--


-- Gibt zu einem QAB die Wendatsätze zurück, die der Lieferant als Ersatzlieferung für reklamierte Ware geschickt hat
CREATE OR REPLACE FUNCTION TQS.Get_wendat_ersatzlieferung(IN q_nr INTEGER,
        OUT w_wen               INTEGER,
        OUT w_aknr              VARCHAR(40),
        OUT w_zugang            NUMERIC,
        OUT w_zugang_uf1        NUMERIC,
        OUT w_zug_dat           TIMESTAMP WITHOUT TIME ZONE,
        OUT w_lgort             VARCHAR(50),
        OUT w_lgchnr            VARCHAR(50),
        OUT w_lfsnr             VARCHAR(30)
        ) RETURNS SETOF RECORD AS $$
 DECLARE r RECORD;
 BEGIN
   FOR r IN SELECT w.w_wen, w.w_aknr, w.w_zugang, w.w_zugang_uf1, w.w_zug_dat,w.w_lgort, w.w_lgchnr, w.w_lfsnr
            FROM wendat w
              LEFT JOIN ldsdok ON w_lds_id =  ld_id
            WHERE w_q_nr = q_nr
               AND w_lds_id IS NOT NULL
               AND ld_code ='E'
               AND ld_q_nr IS NOT NULL
   ORDER BY w_zug_dat DESC LOOP
    w_wen       :=r.w_wen;
    w_aknr      :=r.w_aknr;
    w_zugang    :=r.w_zugang;
    w_zugang_uf1:=r.w_zugang_uf1;
    w_zug_dat   :=r.w_zug_dat;
    w_lgort     :=r.w_lgort;
    w_lgchnr    :=r.w_lgchnr;
    w_lfsnr     :=r.w_lfsnr;
    RETURN NEXT;
  END LOOP;
  RETURN;
 END $$ LANGUAGE plpgsql STABLE;
--


  CREATE OR REPLACE FUNCTION tqs.qab__create_from__service__by__kanfse_id(
      IN _kanfse_id    integer,
      IN _makeQAB      boolean DEFAULT false,
      IN _ak_nr        varchar DEFAULT NULL
      )
      RETURNS integer
      AS $$
      DECLARE result integer;
      BEGIN
         INSERT INTO qab
                     (q_nr,
                      q_dat,
                      q_festext,
                      q_isService,
                      q_kanfse_id,
                      q_ak_nr,
                      q_krzl_apkrzl,
                      q_krzl_ap,
                      q_krzl,
                      q_api,
                      q_typ,
                      q_stk
                      )
              SELECT CASE WHEN NOT _makeQAB THEN
                               getnumcirclenr('qabser')::int
                          ELSE
                               getnumcirclenr('qab')::int
                     END,
                     today(),
                     true,
                     NOT _makeQAB,
                     _kanfse_id,
                     COALESCE( _ak_nr, kanf_ak_nr),
                     kanf_apkrzl,
                     kanf_ap,
                     kanf_ad_krz,
                     kanf_api,
                     ifthen(_makeQAB, 2, 6), -- 2 Artikelbezogen, 6 Servicevorfall
                     coalesce(ag_stk_uf1, ld_stk_uf1, 0)
                FROM kundservicepos
                     JOIN kundanfrage ON kanfse_kanf_nr = kanf_nr
                LEFT JOIN auftg  ON ag_id = kanf_ag_id
                LEFT JOIN ldsdok ON ld_id = kanf_ld_id
               WHERE _kanfse_id = kanfse_id
           RETURNING q_nr INTO result;

           RETURN result;
      END $$ LANGUAGE plpgsql;
--

-- Ermittlung von passenden Prüfmittelnummern anhand der letzten Verwendung
  -- bzgl. einer konkreten Prüfung eines Prüfpunktes
  -- dieses Fertigungsartikels bei diesem Arbeitsgang (über ASK-AG)
  -- des gleichen Prüfers, zwecks persönlicher Prüfmittel (optional)
  -- mit den gleichen Prüfkriterien bzw. der gleichen Prüfmittel-Artikelnr.
CREATE OR REPLACE FUNCTION tqs.oplpm_mw__mw_pr_pmnr__last_used(
      _mw_id                        integer,          -- Ausgangspunkt: die konkrete Prüfung eines Prüfpunkts (oplpm_mw.mw_id)
      _pruefer                      varchar = null,   -- optional: spezifischer Prüfer (llv.ll_db_usename)
      _add_indirect_pm_part_matches boolean = false,  -- mehr Ergebnisse, wo nur die Prüfmittel-Artikelnr. als Kriterium stimmt.
      _limit                        integer = 1,      -- Limitierung der ausgegebenen Zeilen (null = alle)

      OUT oplpm_mw_id integer,  -- ID der anderen Prüfung
      OUT pm_aknr     varchar,  -- Prüfmittel-Artikelnr.
      OUT pr_pmnr     varchar   -- Prüfmittelnummer
  ) RETURNS SETOF record AS $$
  DECLARE
      _src_pruefung record;
  BEGIN
      -- Fehler: Notwendige Daten der konkreten Prüfung in der Messwerterfassung nicht vorhanden.
      IF NOT EXISTS(SELECT true FROM oplpm_mw WHERE mw_id = _mw_id) THEN
          RAISE EXCEPTION '%', lang_text( 16893 );
      END IF;

      -- Fehler: Angegebener Prüfer nicht im Mitarbeiterverzeichnis vorhanden.
      IF _pruefer IS NOT NULL AND NOT EXISTS(SELECT true FROM llv WHERE ll_db_usename = _pruefer) THEN
          RAISE EXCEPTION '%', lang_text( 16894 );
      END IF;


      -- Quelldaten für Suche
      SELECT
        pm_op2_id,
        -- Prüfkriterien
        row( pm_nenn, pm_tol1, pm_tol2, pm_tol3, pm_ma ) AS kriterien,
        pm_part
      FROM oplpm_mw
        JOIN oplpm_data ON pm_id = mw_pm_id
      WHERE mw_id = _mw_id
      INTO
        _src_pruefung
      ;


      -- Ergebnisse ermitteln
      RETURN QUERY
      SELECT
        mw_id,
        pm_part,
        mw_pr_pmnr
      FROM oplpm_mw
        JOIN oplpm_data ON pm_id = mw_pm_id
      WHERE
        -- andere Prüfung
            mw_id <> _mw_id

        -- mit Angabe einer Prüfmittelnummer
        AND mw_pr_pmnr IS NOT NULL

        -- gleicher ASK-AG
        AND pm_op2_id = _src_pruefung.pm_op2_id

        -- gleicher Prüfer für persönliches Prüfmittel (optional)
        AND (
                _pruefer IS NOT NULL
            AND mw_pruefer = _pruefer

            OR  _pruefer IS NULL
        )

        -- Vergleich der Prüfkriterien bzw. Prüfmittel-Artikelnr.
        AND (
            -- direkter Vergleich
            (
                -- Prüfkritierien gleich
                    row( pm_nenn, pm_tol1, pm_tol2, pm_tol3, pm_ma )
                    =
                    _src_pruefung.kriterien
                -- und Prüfmittel-Artikelnr. gleich
                AND pm_part = _src_pruefung.pm_part
            )

            -- indirekter Vergleich (ohne passende Prüfkriterien)
            OR  (
                -- nur gleiche Prüfmittel-Artikelnr. notwendig
                    pm_part = _src_pruefung.pm_part
                -- wenn als Kriterium erlaubt
                AND _add_indirect_pm_part_matches IS TRUE
            )
        )

      ORDER BY
        -- gleiche Prüfkriterien bevorzugen
        row( pm_nenn, pm_tol1, pm_tol2, pm_tol3, pm_ma )
        =
        _src_pruefung.kriterien
        DESC,

        -- jüngste Verwendung bevorzugen
        oplpm_mw.modified_date DESC,
        oplpm_mw.insert_date DESC,

        -- Fallback
        mw_id DESC

      LIMIT _limit
      ;


  END $$ LANGUAGE plpgsql STABLE;
--


CREATE OR REPLACE FUNCTION tqs.oplpm_data__oplpm_mw__pruefplan__aktualisieren(
      _op_ix        integer,         -- ASK-ID, wird nicht benötigt, wenn ABK-ID mitgegeben wird
      _ab_ix        integer,         -- ABK-ID, wenn nicht gesetzt, werden alle offenen ABKs der ASK betrachtet
      _a2_n         integer,         -- Arbeitsgang
      _mw_pm_delete boolean = false, -- leere Messdatensätze und ggf. leere Messprotokolle lössen
      _letztteil    integer = null   -- von der Fertigungsmenge abweichendes Letztteil
  ) RETURNS void AS $$
  DECLARE
      _ab2_ids integer[];
  BEGIN

  -- gleicht die Prüfprotokolle der übergebenen ABK/ASK mit den passenden Prüfplänen ab und passt sie entsprechend an
  -- Löschungen werden nur vorgenommen, wenn der Anwender das wünscht und noch keine Messwerte zum zu löschenden Datensatz vorliegen

    IF
            ( _op_ix IS null AND _ab_ix IS null )
        OR _a2_n IS null
    THEN
        RETURN;
    END IF;

    -- betroffene ABKs ermitteln
    _ab2_ids :=
        array_agg( a2_id ) FROM ab2
        WHERE
              a2_ab_ix IN (
            SELECT _ab_ix
            UNION
            SELECT ab_ix FROM abk WHERE ab_askix = _op_ix
          )
          AND a2_n = _a2_n;

    IF _mw_pm_delete THEN
        -- Schritt 1
        -- löscht Messwerte, sofern _mw_pm_delete gesetzt ist und
        -- es zu dem AG keine Messwerte vorliegen

        DELETE FROM oplpm_mw
        WHERE
                  mw_pm_id IN (
                    SELECT pm_id FROM oplpm_data WHERE pm_a2_id = ANY( _ab2_ids )
            )
        AND mw_messwert IS null;


        -- Schritt 2
        -- löscht Messprotokolle, sofern _mw_pm_delete gesetzt ist und
        -- es zu dem AG keine Messdaten vorliegen - weil sie z.B.
        -- mit dem letzten DELETE gelöscht wurden

        DELETE FROM oplpm_data
        WHERE
                pm_a2_id = ANY( _ab2_ids )
            AND NOT EXISTS(
                    SELECT 1 FROM oplpm_mw WHERE mw_pm_id = pm_id
                );

    END IF;

    -- Schritt 3
    -- fügt teilweise erfasste Messprotokolle erneut hinzu, allerdings ohne Messwerte, falls sich
    -- Erfassungsdaten durch die Attualisierung geändert haben
    INSERT INTO oplpm_data
    (
      pm_op2_id,
      pm_a2_id,
      pm_pmnr,
      pm_pnkt,
      pm_part,
      pm_nenn,
      pm_tol1,
      pm_tol2,
      pm_tol3,
      pm_ma,
      pm_pi,
      pm_fd,
      pm_sta,
      pm_txt,
      pm_intv_typ,
      pm_messwert_bool
    )
    SELECT
      pm_op2_id,
      a2_id AS pm_a2_id,
      pm_pmnr,
      pm_pnkt,
      pm_part,
      pm_nenn,
      pm_tol1,
      pm_tol2,
      pm_tol3,
      pm_ma,
      pm_pi,
      pm_fd,
      pm_sta,
      pm_txt,
      pm_intv_typ,
      pm_messwert_bool
    FROM oplpm_data
    JOIN ab2 ON pm_op2_id = a2_o2_id AND a2_id = ANY( _ab2_ids )
    WHERE pm_a2_id IS null

    EXCEPT

    SELECT
      pm_op2_id,
      pm_a2_id,
      pm_pmnr,
      pm_pnkt,
      pm_part,
      pm_nenn,
      pm_tol1,
      pm_tol2,
      pm_tol3,
      pm_ma,
      pm_pi,
      pm_fd,
      pm_sta,
      pm_txt,
      pm_intv_typ,
      pm_messwert_bool
    FROM oplpm_data
    WHERE pm_a2_id = ANY( _ab2_ids );

    IF _mw_pm_delete THEN
      -- Schritt 1 wiederholen, da Messdatensätze per Trigger hinzugefügt wurden

      DELETE FROM oplpm_mw
      WHERE
            mw_pm_id IN (
            SELECT pm_id FROM oplpm_data WHERE pm_a2_id = ANY( _ab2_ids )
        )
      AND mw_messwert IS null;
    END IF;

    -- Schritt 4
    -- Hinzufügen einzugebender Messwerte
    PERFORM TABK.oplpm_mw__insert_from__oplpm_data( oplpm_data.pm_id, _letztteil )
    FROM oplpm_data
    JOIN oplpm ON oplpm.pm_op2_id = oplpm_data.pm_op2_id
    WHERE
        oplpm_data.pm_a2_id = ANY( _ab2_ids )
        AND oplpm.pm_pmnr = oplpm_data.pm_pmnr
        AND   TQS.oplpm_data__get__pruefpunkt_bezeichnung_komplett(oplpm_data.pm_id)
            = TQS.oplpm_data__get__pruefpunkt_bezeichnung_komplett(oplpm.pm_id);


    -- Schritt 5
    -- Löscht Messwerte, die im letzten Schritt überflüssigerweise hinzugefügt wurden.
  IF _mw_pm_delete THEN
      DELETE FROM oplpm_mw WHERE
          mw_id in (
              SELECT mw1.mw_id from oplpm_mw mw1
              JOIN oplpm_data ON mw1.mw_pm_id = pm_id
              JOIN oplpm_mw mw2 ON
                  mw2.mw_messwert IS NOT null
                  AND pm_pmnr = ( SELECT pm_pmnr FROM oplpm_data WHERE pm_id = mw2.mw_pm_id )
                  AND mw1.mw_lfdnr = mw2.mw_lfdnr
                  AND   TQS.oplpm_data__get__pruefpunkt_bezeichnung_komplett( mw1.mw_pm_id )
                      = TQS.oplpm_data__get__pruefpunkt_bezeichnung_komplett( mw2.mw_pm_id )
                  AND mw1.mw_pm_id = mw2.mw_pm_id
              WHERE
                      pm_a2_id = ANY ( _ab2_ids )
                  AND mw1.mw_messwert IS null
          );
  END IF;

END $$ LANGUAGE plpgsql VOLATILE;
--

-- #18181 Verknüpfung mapsernr zu oplpm_mw, Seriennummer mit neuem Prüfpunkt (bzw. deren Messwerten) verknüpfen
CREATE OR REPLACE FUNCTION tqs.mapsernr__oplpm_mw__add( _lgs_id integer ) RETURNS integer AS $$
DECLARE
  _msmw_id integer;                          -- Id der Verknüpfungstabelle
  _ab_ix integer;                            -- ABK (PA)
  _mw_lfdnr integer;                         -- laufende Nummer des Prüfteils
BEGIN

  -- die ABK zur Produktseriennummer
  _ab_ix := ab_ix
            FROM abk
            JOIN ldsdok ON ld_id = ab_ld_id
            JOIN mapsernr ON ms_pkey = ld_id AND ms_table = 'ldsdok'::REGCLASS
            JOIN lagsernr ON ms_lgs_id = lgs_id
            WHERE lgs_id = _lgs_id;            -- lgs_sernr = _sernr    -- SN

  IF _ab_ix IS null THEN
    RETURN null;
  END IF;

  -- SN-Verknüpfung mit einem Prüfteil (anhand laufender Nummer) bereits zugewiesen
  _mw_lfdnr := DISTINCT mw_lfdnr
               FROM oplpm_mw
               JOIN oplpm_data ON pm_id = mw_pm_id
               JOIN ab2 ON a2_id = pm_a2_id
               JOIN mapsernr_mw ON msmw_abix = a2_ab_ix AND msmw_lfdnr = mw_lfdnr
               JOIN mapsernr ON ms_pkey = msmw_id AND ms_table = 'mapsernr_mw'::REGCLASS
               JOIN lagsernr ON lgs_id = ms_lgs_id
               WHERE lgs_id = _lgs_id;          -- lgs_sernr = _sernr    -- SN

  IF ( _mw_lfdnr IS null ) THEN

    -- freie laufende Prüfteil-Nummer suchen
    _mw_lfdnr := DISTINCT mw_lfdnr
                 FROM oplpm_mw
                 JOIN oplpm_data ON pm_id = mw_pm_id
                 JOIN ab2 ON a2_id = pm_a2_id
                 WHERE a2_ab_ix = _ab_ix
                   AND (mw_lfdnr NOT IN (SELECT msmw_lfdnr FROM mapsernr_mw WHERE msmw_abix = a2_ab_ix))
                 ORDER BY mw_lfdnr
                 LIMIT 1;

  END IF;

  -- nichts gefunden - dann fertig
  IF _mw_lfdnr IS null THEN
    RETURN null;
  END IF;

  -- Verknüpfung zu ABK+Messpunkt ermitteln bzw. anlegen
  _msmw_id := msmw_id FROM mapsernr_mw WHERE msmw_abix = _ab_ix AND msmw_lfdnr = _mw_lfdnr;

  IF _msmw_id IS null THEN

    INSERT INTO mapsernr_mw
      ( msmw_abix, msmw_lfdnr )
    VALUES
      ( _ab_ix   , _mw_lfdnr  )
    RETURNING msmw_id INTO _msmw_id;

  END IF;

    -- Verknüpfung zu mapsernr
  IF NOT EXISTS(
    SELECT 1 FROM mapsernr
    WHERE
          ms_lgs_id = _lgs_id
      AND ms_table = 'mapsernr_mw'::REGCLASS
      AND ms_pkey = _msmw_id
    ) THEN

    INSERT INTO mapsernr
      ( ms_lgs_id, ms_table               , ms_pkey  )
    VALUES
      ( _lgs_id  , 'mapsernr_mw'::REGCLASS, _msmw_id );

  END IF;

  RETURN _msmw_id;

END $$ LANGUAGE plpgsql STRICT;
--
--- #21398
CREATE OR REPLACE FUNCTION TQS.oplpm_data__get__pruefpunkt_report_pruefmittellegende__krz(
    IN _a2_id       integer
    )
    RETURNS TABLE (
      leg_pm_pmnr_krz      varchar,   -- M1, M2, etc..
      leg_pm_part          varchar    -- Prüfmittel
    )
    AS $$
    SELECT
      CONCAT('M', row_number() OVER (ORDER BY MIN(pm_pmnr)))::VARCHAR AS leg_pm_pmnr_krz,
      pm_part AS leg_pm_part
    FROM oplpm_data
      LEFT JOIN ab2 ON pm_a2_id = a2_id
    WHERE a2_id = _a2_id
    GROUP BY pm_part
    ORDER BY pm_part;
 $$ LANGUAGE sql;
---
CREATE OR REPLACE FUNCTION TQS.oplpm_data__get__pruefpunkt_report_pruefhinweise__krz(
    IN _a2_id       integer
    )
    RETURNS TABLE (
      hinw_pm_pmnr_krz      varchar,   -- H1, H2, etc..
      hinw_pm_pmnr          integer    -- Prüfnummer
    )
    AS $$
    SELECT
      CONCAT('H', row_number() OVER (ORDER BY pm_pmnr))::VARCHAR AS hinw_pm_pmnr_krz,
      pm_pmnr AS hinw_pm_pmnr
    FROM ab2
      LEFT JOIN oplpm_data ON pm_a2_id = a2_id
    WHERE a2_id = _a2_id
      AND COALESCE( TRIM( pm_txt ), '') <> ''
    ORDER BY pm_pmnr;
 $$ LANGUAGE sql;

--- #21764, 22026 Löscht mehrere Teilenummern aus einem Messprotokoll
CREATE OR REPLACE FUNCTION tqs.oplpm_mw__ab2__delete(
        _a2_ab_ix                  integer,
        _a2_n                      integer,
        _teilenummern              varchar,
        _loeschen_nachfolgende_ags boolean DEFAULT false, -- auch für alle folgendne Arbeitsgänge der ABK?
        _oplpm_delete              boolean DEFAULT false  -- leere Prüfpunkte im Messprotokoll auch löschen?
    ) RETURNS void AS $$
  DECLARE
    _tn_list integer[];
    _a2_ids integer[];
  BEGIN

    -- Parsen des Inputstrings
    _tn_list := integer_list__from__inputstring__get( _teilenummern );

    -- die betroffenne Arbeitsgänge zusammensuchen
    _a2_ids := array_agg( a2_id ) FROM ab2
                WHERE a2_ab_ix = _a2_ab_ix
                  AND ( a2_n = _a2_n OR ( _loeschen_nachfolgende_ags AND a2_n > _a2_n ));


    -- Löschen der fraglichen Messpunkte nur, wenn keine Messwerte eingetragen
    DELETE FROM oplpm_mw
    WHERE mw_id in (
      SELECT mw_id
      FROM oplpm_mw
      JOIN oplpm_data ON mw_pm_id = pm_id
      JOIN ab2 ON a2_id = pm_a2_id
      WHERE a2_id = ANY( _a2_ids )
        AND mw_lfdnr = ANY( _tn_list )
        AND NOT mw_definitiv
        AND mw_messwert IS null

    );

    -- Wenn Option gesetzt, dann auch noch Prüfprotokoll von leeren Prüfpunkten säubern
    IF _oplpm_delete THEN
      DELETE FROM oplpm_data
      WHERE pm_id in(
        SELECT DISTINCT pm_id
        FROM oplpm_data
        JOIN ab2 ON a2_id = pm_a2_id
        WHERE a2_ab_ix = ANY( _a2_ids )
        AND NOT EXISTS( SELECT 1 FROM oplpm_mw WHERE mw_pm_id = pm_id )
      );

    END IF;
 END $$ LANGUAGE plpgsql;
 --